#include <afxwin.h>
#define ID_ADDBUTTON   1000
#define ID_DELETEBUTTON   1001
#define ID_AMENDBUTTON   1002
#define ID_STATIC   1003
#define ID_EDIT   1004
#define IDC_LIST1 1005
class CSimpleApp : public CWinApp
{
public:
BOOL InitInstance();
};

class CMainFrame : public CFrameWnd
{
public:
CMainFrame();
afx_msg void wAddButtonOnClick();
afx_msg void wDeleteButtonOnClick();
afx_msg void wAmendButtonOnClick();
afx_msg void wListBoxChange();
DECLARE_MESSAGE_MAP()

//instantiate button class;
CButton wAddButton;
CButton wDeleteButton;
CButton wAmendButton;
//instantiate edit class;
CEdit wEdit;
//instantiate combobox class;
CComboBox wComboBox;

};

BOOL CSimpleApp::InitInstance()
{
m_pMainWnd = new CMainFrame();
m_pMainWnd->ShowWindow(m_nCmdShow);
return TRUE;
}

CMainFrame::CMainFrame()
{
Create(NULL,TEXT( "combo box example"), WS_OVERLAPPEDWINDOW ,CRect(25,25,410,270));
wComboBox.Create(WS_CHILD | WS_VISIBLE |CBS_DROPDOWN ,CRect(10,25,300,150), this, IDC_LIST1);
//add listbox records
wComboBox.AddString(TEXT("Apple"));
wComboBox.AddString(TEXT("Orange"));
wComboBox.AddString(TEXT("Pear"));

wEdit.Create(WS_CHILD | WS_VISIBLE | WS_BORDER , CRect(10,100,300,140), this, ID_EDIT);
wAddButton.Create(TEXT("Add"),BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_BORDER, CRect(10,150,80,180), this, ID_ADDBUTTON);
wDeleteButton.Create(TEXT("Delete"),BS_PUSHBUTTON |WS_CHILD | WS_VISIBLE | WS_BORDER , CRect(90,150,170,180), this, ID_DELETEBUTTON);
wAmendButton.Create(TEXT("Amend"),BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_BORDER , CRect(180,150,250,180), this, ID_AMENDBUTTON);
}

BEGIN_MESSAGE_MAP(CMainFrame,CFrameWnd)
//message map
ON_BN_CLICKED(ID_ADDBUTTON,wAddButtonOnClick)
ON_BN_CLICKED(ID_DELETEBUTTON,wDeleteButtonOnClick)
ON_BN_CLICKED(ID_AMENDBUTTON,wAmendButtonOnClick)
ON_WM_PAINT()
ON_LBN_SELCHANGE(IDC_LIST1,wListBoxChange)
END_MESSAGE_MAP()

CSimpleApp MFCApp1;

//add item to combobox
afx_msg void CMainFrame::wAddButtonOnClick()
{
CString strText;
wEdit.GetWindowText(strText);
if (strText!="")//check textbox is not empty
{
wComboBox.AddString(strText);
}
}

//delete selected item from combobox
afx_msg void CMainFrame::wDeleteButtonOnClick()
{
int i = wComboBox.GetCurSel(); 
if (i!=-1)//checks listbox item is selected
{
wComboBox.DeleteString(i);
wEdit.SetWindowText(TEXT(""));
}
}

//amend combobox item
afx_msg void CMainFrame::wAmendButtonOnClick()
{
int i = wComboBox.GetCurSel(); 
CString strText;
wEdit.GetWindowText(strText);
if (strText!="")//checks textbox is not empty
{
wComboBox.DeleteString(i);
wComboBox.AddString(strText);
}
}

//detects for selected combobox change
afx_msg void CMainFrame::wListBoxChange()
{
CString strText;
int i = wComboBox.GetCurSel(); 
wComboBox.GetLBText(i,strText);
wEdit.SetWindowText( strText);//sets textbox to selected listbox item
}